-- Captain Trade Bot Database Schema
-- Professional Forex Trading Course System

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";

-- Users table
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `username` varchar(255) DEFAULT NULL,
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `chat_id` bigint(20) NOT NULL,
  `mobile_number` varchar(20) DEFAULT NULL,
  `license_key` text DEFAULT NULL,
  `is_verified` tinyint(1) DEFAULT 0,
  `user_state` varchar(50) DEFAULT NULL,
  `otp_code` varchar(255) DEFAULT NULL,
  `otp_created_at` timestamp NULL DEFAULT NULL,
  `verified_at` timestamp NULL DEFAULT NULL,
  `last_activity` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `payment_id` int(11) DEFAULT NULL,
  `subscription_end` timestamp NULL DEFAULT NULL,
  `login_attempts` int(11) DEFAULT 0,
  `is_blocked` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `idx_username` (`username`),
  KEY `idx_mobile` (`mobile_number`),
  KEY `idx_verified` (`is_verified`),
  KEY `idx_state` (`user_state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- User activities log
CREATE TABLE `user_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `username` varchar(255) DEFAULT NULL,
  `first_name` varchar(255) DEFAULT NULL,
  `action` text NOT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Student menus (admin-managed)
CREATE TABLE `student_menus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `content_type` enum('text','link','file','video','channel','faq') DEFAULT 'text',
  `icon` varchar(50) DEFAULT '📋',
  `sort_order` int(11) DEFAULT 0,
  `is_active` tinyint(1) DEFAULT 1,
  `access_count` int(11) DEFAULT 0,
  `requires_subscription` tinyint(1) DEFAULT 1,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_active_order` (`is_active`, `sort_order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Payments table
CREATE TABLE `payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `payment_method` enum('zarinpal','card_to_card','crypto','admin') NOT NULL,
  `transaction_id` varchar(255) DEFAULT NULL,
  `ref_id` varchar(255) DEFAULT NULL,
  `status` enum('pending','completed','failed','cancelled','reviewing') DEFAULT 'pending',
  `receipt_image` text DEFAULT NULL,
  `admin_notes` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `verified_by` varchar(100) DEFAULT NULL,
  `verification_date` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_payment` (`user_id`, `status`),
  KEY `idx_transaction` (`transaction_id`),
  KEY `idx_status` (`status`),
  KEY `idx_method` (`payment_method`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- SpotPlayer licenses
CREATE TABLE `spotplayer_licenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `payment_id` int(11) DEFAULT NULL,
  `license_id` varchar(255) NOT NULL,
  `license_key` text NOT NULL,
  `download_url` text DEFAULT NULL,
  `course_ids` json DEFAULT NULL,
  `is_test` tinyint(1) DEFAULT 0,
  `is_active` tinyint(1) DEFAULT 1,
  `expires_at` timestamp NULL DEFAULT NULL,
  `last_used` timestamp NULL DEFAULT NULL,
  `usage_count` int(11) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `license_id` (`license_id`),
  KEY `idx_user_license` (`user_id`, `is_active`),
  KEY `idx_payment` (`payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Admin settings
CREATE TABLE `admin_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(100) NOT NULL,
  `setting_value` longtext DEFAULT NULL,
  `setting_type` enum('string','integer','boolean','json','text') DEFAULT 'string',
  `description` text DEFAULT NULL,
  `category` varchar(50) DEFAULT 'general',
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_by` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `setting_key` (`setting_key`),
  KEY `idx_category` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insert default student menus
INSERT INTO `student_menus` (`title`, `content`, `content_type`, `icon`, `sort_order`) VALUES
('🎬 ویدیوهای آموزشی', 'برای مشاهده ویدیوهای آموزشی، لطفا از لایسنس خود در اپلیکیشن SpotPlayer استفاده کنید.\n\n🔗 لینک دانلود SpotPlayer:\nhttps://spotplayer.ir', 'text', '🎬', 1),
('📊 سیگنال‌های معاملاتی', '🔥 کانال سیگنال‌های طلایی کاپیتان ترید!\n\n💎 سیگنال‌های بلندمدت با دقت بالا\n📈 فارکس، بورس، ارز دیجیتال و طلا\n💰 ارزش ماهانه بیش از 100 دلار\n\n🔗 برای عضویت با پشتیبانی تماس بگیرید:\n@capitantrade_admin', 'text', '📊', 2),
('💎 گروه VIP دانشجویان', '👥 گروه اختصاصی دانشجویان دوره\n\n✨ ویژگی‌ها:\n• 20 ادمین از دانشجویان موفق\n• رفع اشکال مستقیم\n• تجربه‌های معاملاتی\n• انگیزه و انرژی مثبت\n\n📱 برای دعوت به گروه منتظر بمانید یا با پشتیبانی تماس بگیرید.', 'text', '💎', 3),
('📸 کلوز فرند اینستاگرام', '🎯 کلوز فرند اختصاصی کاپیتان ترید\n\n🔴 ویژگی‌ها:\n• لایو ترید روزانه\n• آموزش‌های کوتاه و مفید\n• تحلیل بازار لحظه‌ای\n• پاسخ سوالات مستقیم\n\n📸 اینستاگرام: @capitan.trade\n💌 برای عضویت در کلوز فرند، پیام "دوره" را در دایرکت ارسال کنید.', 'text', '📸', 4),
('❓ سوالات متداول', '🔍 پاسخ سوالات رایج:\n\n❓ چطور لایسنس را فعال کنم؟\n✅ لایسنس را در اپلیکیشن SpotPlayer وارد کنید.\n\n❓ ویدیوها کجا هستند؟\n✅ تمام ویدیوها در اپلیکیشن SpotPlayer قابل مشاهده هستند.\n\n❓ چطور به گروه VIP بپیوندم؟\n✅ بعد از فعال‌سازی لایسنس، لینک گروه برایتان ارسال می‌شود.\n\n❓ سوال دیگری دارید؟\n💬 با پشتیبانی تماس بگیرید: @capitantrade_admin', 'text', '❓', 5),
('📞 پشتیبانی اختصاصی', '🎯 پشتیبانی 24 ساعته کاپیتان ترید\n\n📱 تلگرام: @capitantrade_admin\n📸 اینستاگرام: @capitan.trade\n\n⏰ ساعات پاسخگویی: 8 صبح تا 12 شب\n\n💡 برای پاسخ سریع‌تر، سوال خود را کامل و واضح بپرسید.\n\n🔥 ما همیشه در کنار شما هستیم!', 'text', '📞', 6);

-- Insert default admin settings
INSERT INTO `admin_settings` (`setting_key`, `setting_value`, `setting_type`, `description`, `category`) VALUES
('maintenance_mode', 'false', 'boolean', 'حالت تعمیرات', 'system'),
('welcome_message_active', 'true', 'boolean', 'نمایش پیام خوشامدگویی', 'messages'),
('auto_license_creation', 'true', 'boolean', 'ایجاد خودکار لایسنس', 'spotplayer'),
('payment_card_active', 'true', 'boolean', 'فعال بودن پرداخت کارت به کارت', 'payment'),
('payment_zarinpal_active', 'false', 'boolean', 'فعال بودن پرداخت زرین‌پال', 'payment'),
('course_discount_percent', '0', 'integer', 'درصد تخفیف دوره', 'course'),
('max_login_attempts', '5', 'integer', 'حداکثر تلاش ورود', 'security'),
('otp_expiry_minutes', '5', 'integer', 'مدت اعتبار کد تایید (دقیقه)', 'security');

COMMIT;