<?php
/**
 * ULTIMATE Messages Class - Complete & Professional
 * Advanced Copywriting + Perfect Integration
 * Updated: 2025-10-15 19:28:15 UTC
 * Created by: saportinsta65
 */

class Messages {
    
    /**
     * 🎯 پیام خوشامدگویی حرفه‌ای
     */
    public static function getWelcomeMessage($first_name) {
        $greeting = self::getTimeGreeting();
        
        return "{$greeting} <b>{$first_name}</b> عزیز! 👋

🎯 <b>به دنیای معاملات حرفه‌ای خوش آمدید</b>

💫 کاپیتان ترید، برترین مرجع آموزش فارکس در ایران

🔥 <b>چرا ما متفاوتیم؟</b>
✨ 5+ سال تجربه اثبات شده
📈 10,000+ دانشجوی موفق  
💰 سیستم‌های سودآور PLS
🎓 آموزش کاملاً عملی

━━━━━━━━━━━━━━━━━━━━

🚀 <b>آماده شروع سفر موفقیت هستید؟</b>";
    }
    
    /**
     * ⏰ سلام بر اساس زمان
     */
    private static function getTimeGreeting() {
        $hour = (int)date('H', time() + (3.5 * 3600)); // Iran time
        
        if ($hour >= 5 && $hour < 12) {
            return "🌅 صبح بخیر";
        } elseif ($hour >= 12 && $hour < 17) {
            return "☀️ ظهر بخیر";
        } elseif ($hour >= 17 && $hour < 21) {
            return "🌆 عصر بخیر";
        } else {
            return "🌙 شب بخیر";
        }
    }
    
    /**
     * 🎹 منوی اصلی
     */
    public static function getMainMenuKeyboard() {
        return [
            'keyboard' => [
                [
                    ['text' => '🎓 ورود دانشجویان'],
                    ['text' => '📚 شروع یادگیری']
                ],
                [
                    ['text' => '💬 پشتیبانی'],
                    ['text' => '🌟 درباره کاپیتان']
                ]
            ],
            'resize_keyboard' => true,
            'one_time_keyboard' => false
        ];
    }
    
    /**
     * 📚 اطلاعات دوره
     */
    public static function getCourseInfoMessage() {
        $price = number_format(COURSE_PRICE);
        
        return "🚀 <b>دوره جامع تبدیل به معامله‌گر حرفه‌ای</b>

🎯 <b>سیستم PLS - کلید طلایی موفقیت</b>

━━━━━━━━━━━━━━━━━━━━

📊 <b>آنچه یاد می‌گیرید:</b>

🧠 <b>ذهنیت میلیونری:</b>
• روانشناسی معاملات
• مدیریت احساسات
• کنترل ترس و طمع

📈 <b>مهارت‌های فنی:</b>
• تحلیل تکنیکال پیشرفته  
• سیستم معاملاتی PLS
• مدیریت ریسک حرفه‌ای

💰 <b>استراتژی‌های سودآور:</b>
• الگوهای قیمتی طلایی
• نقاط ورود دقیق
• خروج با حداکثر سود

━━━━━━━━━━━━━━━━━━━━

💎 <b>قیمت دوره:</b> {$price} تومان

🎁 <b>بونوس‌های ویژه:</b>
🔔 کانال سیگنال‌های VIP
👥 گروه دانشجویان موفق
📞 پشتیبانی 24/7

⏰ <b>آماده تغییر زندگی هستید؟</b>";
    }
    
    /**
     * 💳 گزینه‌های پرداخت
     */
    public static function getPaymentMethodKeyboard() {
        return [
            'keyboard' => [
                [
                    ['text' => '💳 پرداخت آنلاین فوری'],
                    ['text' => '💰 کارت به کارت']
                ],
                [
                    ['text' => '🔙 بازگشت']
                ]
            ],
            'resize_keyboard' => true,
            'one_time_keyboard' => false
        ];
    }
    
    /**
     * 🔐 انتخاب روش ورود
     */
    public static function getSelectLoginMethodMessage() {
        return "🎓 <b>ورود به آکادمی کاپیتان ترید</b>

━━━━━━━━━━━━━━━━━━━━

🔐 <b>روش ورود خود را انتخاب کنید:</b>

🎫 <b>ورود با لایسنس:</b>
برای دانشجویان دارای لایسنس دوره

📱 <b>ورود با شماره موبایل:</b>
احراز هویت سریع با کد تایید

━━━━━━━━━━━━━━━━━━━━

💎 <b>دنیای آموزش‌های حرفه‌ای در انتظارتان!</b>";
    }
    
    /**
     * 🎹 منوی ورود
     */
    public static function getLoginMethodKeyboard() {
        return [
            'keyboard' => [
                [
                    ['text' => '🎫 ورود با لایسنس'],
                    ['text' => '📱 ورود با موبایل']
                ],
                [
                    ['text' => '🔙 منوی اصلی']
                ]
            ],
            'resize_keyboard' => true,
            'one_time_keyboard' => false
        ];
    }
    
    /**
     * 🎫 راهنمای ورود لایسنس
     */
    public static function getEnterLicenseMessage() {
        return "🎫 <b>ورود لایسنس دوره</b>

━━━━━━━━━━━━━━━━━━━━

📝 <b>لایسنس خود را وارد کنید:</b>

💡 <b>راهنمایی:</b>
• لایسنس پس از خرید ارسال شده
• کد طولانی و منحصر به فرد
• دقت کنید کامل کپی کنید

🔒 <b>مثال:</b>
<code>00015dcab540796f5d4d...</code>

━━━━━━━━━━━━━━━━━━━━

✍️ <b>لایسنس را در پیام بعدی بفرستید:</b>";
    }
    
    /**
     * 📱 راهنمای ورود موبایل
     */
    public static function getEnterMobileMessage() {
        return "📱 <b>ورود شماره موبایل</b>

━━━━━━━━━━━━━━━━━━━━

📞 <b>شماره موبایل خود را وارد کنید:</b>

✅ <b>فرمت صحیح:</b>
<code>09xxxxxxxxx</code>

❌ <b>فرمت اشتباه:</b>
+98, 0098, 9xxxxxxxx

💡 <b>مثال:</b>
<code>09121234567</code>

━━━━━━━━━━━━━━━━━━━━

🔐 <b>کد تایید 6 رقمی ارسال خواهد شد</b>

✍️ <b>شماره را در پیام بعدی بفرستید:</b>";
    }
    
    /**
     * 🎉 ورود موفق
     */
    public static function getLoginSuccessMessage() {
        return "🎉 <b>تبریک! ورود موفقیت‌آمیز</b>

━━━━━━━━━━━━━━━━━━━━

✨ <b>شما با موفقیت وارد پنل دانشجویی شدید!</b>

🎯 <b>دسترسی کامل به:</b>

🎬 ویدیوهای آموزشی اختصاصی
📊 سیگنال‌های معاملاتی طلایی  
💬 گروه‌های VIP دانشجویان
📞 پشتیبانی اختصاصی 24/7
📈 ابزارهای تحلیل پیشرفته

━━━━━━━━━━━━━━━━━━━━

🚀 <b>آماده شروع سفر سودآوری؟</b>";
    }
    
    /**
     * 🎯 پنل دانشجویی
     */
    public static function getStudentDashboardMessage($first_name = '') {
        return "🎯 <b>پنل دانشجویی کاپیتان ترید</b>

━━━━━━━━━━━━━━━━━━━━

💎 سلام <b>{$first_name}</b> عزیز!

🔥 <b>شما عضو خانواده کاپیتان ترید هستید!</b>

📚 <b>تمام محتواها اختصاصی شماست:</b>

━━━━━━━━━━━━━━━━━━━━

📖 <b>از منو گزینه مورد نظرتان را انتخاب کنید:</b>";
    }
    
    /**
     * 🎹 منوی پنل دانشجویی
     */
    public static function getStudentDashboardKeyboard($menus) {
        $keyboard = [];
        $row = [];
        
        foreach ($menus as $index => $menu) {
            $row[] = ['text' => $menu['icon'] . ' ' . $menu['title']];
            
            if (count($row) == 2 || $index == count($menus) - 1) {
                $keyboard[] = $row;
                $row = [];
            }
        }
        
        $keyboard[] = [
            ['text' => '🔄 به‌روزرسانی پنل'],
            ['text' => '🏠 منوی اصلی']
        ];
        
        return [
            'keyboard' => $keyboard,
            'resize_keyboard' => true,
            'one_time_keyboard' => false
        ];
    }
    
    /**
     * 💬 پشتیبانی
     */
    public static function getSupportMessage() {
        return "📞 <b>پشتیبانی حرفه‌ای کاپیتان ترید</b>

━━━━━━━━━━━━━━━━━━━━

🎯 <b>ما همیشه در کنار شما هستیم!</b>

📱 <b>راه‌های ارتباط:</b>

💬 <b>تلگرام (پاسخ فوری):</b>
" . SUPPORT_USERNAME . "

📸 <b>اینستاگرام:</b>
" . INSTAGRAM_PAGE . "

━━━━━━━━━━━━━━━━━━━━

⏰ <b>ساعات پاسخگویی:</b>
🕐 8 صبح تا 12 شب

💡 <b>برای پاسخ سریع:</b>
• سوال کامل و واضح بپرسید
• عکس یا فایل ضروری بفرستید
• صبور باشید، پاسخ حتمی است

━━━━━━━━━━━━━━━━━━━━

🔥 <b>تیم پشتیبانی آماده کمک به شماست!</b>";
    }
    
    /**
     * 🌟 درباره کاپیتان ترید - ✅ جدید
     */
    public static function getAboutMessage() {
        return "🌟 <b>کاپیتان ترید - داستان موفقیت</b>

━━━━━━━━━━━━━━━━━━━━

👨‍🎓 <b>مجید لطفی (کاپیتان ترید)</b>
🏆 برترین مدرس بازارهای مالی ایران

📈 <b>تجربه و تخصص:</b>
• 5+ سال فعالیت حرفه‌ای
• تحلیل‌گر بین‌المللی معتبر  
• مدرس آکادمی‌های معتبر جهان

━━━━━━━━━━━━━━━━━━━━

🎯 <b>دستاوردها:</b>
• 10,000+ دانشجوی موفق
• 85%+ نرخ موفقیت
• 2,000+ ساعت آموزش
• رتبه 1 پلتفرم‌های معتبر

💰 <b>عملکرد معاملاتی:</b>
• بازدهی متوسط 15-30% ماهانه
• مدیریت پرتفوی میلیون دلاری
• رکوردهای ثبت شده جهانی

━━━━━━━━━━━━━━━━━━━━

🎨 <b>تخصص‌ها:</b>
🧠 سیستم PLS انحصاری
📈 تحلیل تکنیکال پیشرفته
🛡️ مدیریت ریسک حرفه‌ای
💭 روانشناسی معاملات

━━━━━━━━━━━━━━━━━━━━

🎪 <b>مأموریت:</b>
تبدیل افراد عادی به معامله‌گران حرفه‌ای

💎 <b>شعار کاپیتان:</b>
«از صفر تا قله، با علم و عمل!»";
    }
    
    /**
     * 🔙 دکمه بازگشت
     */
    public static function getBackKeyboard() {
        return [
            'keyboard' => [
                [
                    ['text' => '🔙 بازگشت به منوی اصلی']
                ]
            ],
            'resize_keyboard' => true,
            'one_time_keyboard' => false
        ];
    }
    
    /**
     * ❌ پیام‌های خطا
     */
    public static function getInvalidLicenseMessage() {
        return "❌ <b>لایسنس نامعتبر</b>

━━━━━━━━━━━━━━━━━━━━

🔍 <b>لایسنس وارد شده صحیح نیست</b>

💡 <b>دلایل احتمالی:</b>
• اشتباه در کپی کردن
• لایسنس منقضی شده  
• قبلاً استفاده شده

━━━━━━━━━━━━━━━━━━━━

🛠️ <b>راه‌حل:</b>
✅ دوباره کامل کپی کنید
📞 با پشتیبانی تماس بگیرید

💬 <b>پشتیبانی:</b> " . SUPPORT_USERNAME . "

🔄 <b>یا روش دیگری انتخاب کنید</b>";
    }
    
    public static function getInvalidMobileMessage() {
        return "❌ <b>شماره موبایل نامعتبر</b>

━━━━━━━━━━━━━━━━━━━━

📱 <b>فرمت صحیح را رعایت کنید:</b>

✅ <b>درست:</b> <code>09xxxxxxxxx</code>
❌ <b>غلط:</b> +98, 0098, 9xxxxxxxx

💡 <b>مثال صحیح:</b>
<code>09121234567</code>

━━━━━━━━━━━━━━━━━━━━

🔄 <b>دوباره با فرمت صحیح وارد کنید:</b>";
    }
    
    public static function getInvalidOTPMessage() {
        return "❌ <b>کد تایید اشتباه یا منقضی</b>

━━━━━━━━━━━━━━━━━━━━

🔢 <b>کد وارد شده صحیح نیست</b>

💡 <b>نکات مهم:</b>
• کد تایید دقیقاً 6 رقم است
• 5 دقیقه اعتبار دارد
• فاصله اضافی نداشته باشد
• هر کد فقط یکبار قابل استفاده است

━━━━━━━━━━━━━━━━━━━━

🔐 <b>اگر کد منقضی شده، دوباره درخواست کنید</b>

🔄 <b>کد صحیح را وارد کنید:</b>";
    }
    
    /**
     * 🤔 پیام پیش‌فرض
     */
    public static function getDefaultResponse() {
        return "🤔 <b>متوجه نشدم!</b>

━━━━━━━━━━━━━━━━━━━━

💡 <b>راهنمایی:</b>
• از دکمه‌های منو استفاده کنید
• یا دستور /start بزنید

🔄 <b>شروع مجدد:</b> /start

━━━━━━━━━━━━━━━━━━━━

📞 <b>پشتیبانی:</b> " . SUPPORT_USERNAME . "

🔥 <b>همیشه آماده کمک هستیم!</b>";
    }
    
    /**
     * 👋 پیام‌های احوال‌پرسی - ✅ جدید
     */
    public static function getGreetingResponse() {
        $greetings = [
            "👋 سلام! به خانواده کاپیتان ترید خوش آمدید!

✨ <b>آماده تبدیل شدن به معامله‌گر حرفه‌ای هستید؟</b>

🎯 از منوی زیر شروع کنید!",

            "🌟 سلام دوست عزیز!

🎯 <b>امروز چطور می‌تونم توی مسیر موفقیتتان کمکتان کنم؟</b>

💎 بیایید همین حالا شروع کنیم!",

            "🔥 سلام! خوشحالیم که اینجا هستید!

💫 <b>دنیای معاملات حرفه‌ای در انتظارتان!</b>

🚀 آماده برای شروع سفر موفقیت؟"
        ];
        
        return $greetings[array_rand($greetings)];
    }
    
    /**
     * 💰 پرداخت کارت به کارت
     */
    public static function getCardPaymentMessage() {
        $price = number_format(COURSE_PRICE);
        
        return "💳 <b>پرداخت امن کارت به کارت</b>

━━━━━━━━━━━━━━━━━━━━

💳 <b>شماره کارت:</b>
<code>" . CARD_NUMBER . "</code>

👤 <b>نام صاحب حساب:</b>
" . CARD_HOLDER . "

💰 <b>مبلغ:</b> <b>{$price} تومان</b>

━━━━━━━━━━━━━━━━━━━━

⚡ <b>مراحل پرداخت:</b>

1️⃣ مبلغ را واریز کنید
2️⃣ عکس رسید را بفرستید
3️⃣ لایسنس را دریافت کنید

━━━━━━━━━━━━━━━━━━━━

🛡️ <b>پرداخت کاملاً امن</b>
🏆 بیش از 10,000 پرداخت موفق

⏰ <b>پس از واریز، رسید را بفرستید...</b>";
    }
    
    /**
     * 🎁 بسته خوشامدگویی - ✅ جدید
     */
    public static function getWelcomePackage() {
        return "🎁 <b>بسته خوشامدگویی ویژه</b>

━━━━━━━━━━━━━━━━━━━━

🎉 <b>تبریک! شما الان عضو رسمی خانواده کاپیتان ترید هستید!</b>

🎪 <b>هدیه‌های ویژه برای شما:</b>

📚 <b>کتابخانه دیجیتال:</b>
• راهنمای کامل تحلیل تکنیکال
• کتاب روانشناسی معاملات
• راهنمای مدیریت ریسک

━━━━━━━━━━━━━━━━━━━━

🎬 <b>ویدیوهای بونوس اختصاصی:</b>
• 10 اشتباه رایج معامله‌گران
• راز انتخاب بهترین بروکر
• نحوه استفاده از اخبار در معاملات

━━━━━━━━━━━━━━━━━━━━

💎 <b>دسترسی‌های VIP:</b>
🔔 کانال سیگنال‌های اختصاصی
👥 گروه چت دانشجویان موفق
🎥 وبینارهای زنده هفتگی
📞 پشتیبانی اولویت‌دار

━━━━━━━━━━━━━━━━━━━━

🚀 <b>حالا می‌تونید از پنل دانشجویی استفاده کنید!</b>";
    }
    
    /**
     * 📧 تایید دریافت رسید - ✅ جدید
     */
    public static function getPaymentConfirmationMessage($payment_id) {
        return "✅ <b>رسید با موفقیت دریافت شد!</b>

━━━━━━━━━━━━━━━━━━━━

🆔 <b>کد پیگیری شما:</b>
<code>{$payment_id}</code>

⏳ <b>وضعیت پردازش:</b>
رسید شما در صف بررسی قرار گرفت

━━━━━━━━━━━━━━━━━━━━

⏰ <b>زمان بررسی:</b>
حداکثر 15-30 دقیقه

📬 <b>مرحله بعدی:</b>
پس از تایید، لایسنس دوره برایتان ارسال می‌شود

━━━━━━━━━━━━━━━━━━━━

📞 <b>پیگیری:</b> " . SUPPORT_USERNAME . "

💎 <b>ممنون از اعتماد شما به کاپیتان ترید!</b>";
    }
    
    /**
     * 🎫 تحویل لایسنس - ✅ جدید
     */
    public static function getLicenseDeliveryMessage($license_key, $download_url) {
        return "🎉 <b>تبریک! پرداخت شما تایید شد!</b>

━━━━━━━━━━━━━━━━━━━━

✅ <b>لایسنس دوره آماده است:</b>

🎫 <b>کد لایسنس شما:</b>
<code>{$license_key}</code>

━━━━━━━━━━━━━━━━━━━━

📱 <b>مراحل فعال‌سازی:</b>

1️⃣ <b>دانلود اپلیکیشن:</b>
{$download_url}

2️⃣ <b>ورود لایسنس:</b>
لایسنس را در اپلیکیشن SpotPlayer وارد کنید

3️⃣ <b>لذت ببرید:</b>
از تمام ویدیوهای آموزشی استفاده کنید

━━━━━━━━━━━━━━━━━━━━

🎯 <b>حالا می‌تونید از ربات هم استفاده کنید:</b>
دستور /start را بزنید و با لایسنس وارد شوید

━━━━━━━━━━━━━━━━━━━━

🎪 <b>به خانواده بزرگ کاپیتان ترید خوش آمدید!</b>
💫 سفر موفقیت شما از همین حالا شروع می‌شود!";
    }
    
    /**
     * 📸 راهنمای ارسال رسید - ✅ جدید
     */
    public static function getReceiptInstructions() {
        return "📸 <b>راهنمای ارسال رسید</b>

━━━━━━━━━━━━━━━━━━━━

✨ <b>برای تایید سریع، این مراحل را دنبال کنید:</b>

📷 <b>1. عکس‌گیری:</b>
• رسید را واضح و خوانا بگیرید
• نور کافی داشته باشد
• تمام اطلاعات در عکس باشد

━━━━━━━━━━━━━━━━━━━━

📋 <b>2. اطلاعات مورد نیاز:</b>
✅ مبلغ واریزی
✅ تاریخ و ساعت
✅ شماره کارت مقصد
✅ شماره پیگیری (در صورت وجود)

━━━━━━━━━━━━━━━━━━━━

📤 <b>3. ارسال:</b>
عکس را همین‌جا در همین چت ارسال کنید

━━━━━━━━━━━━━━━━━━━━

⏰ <b>زمان بررسی:</b> 15-30 دقیقه

💡 <b>نکته:</b> عکس واضح = تایید سریع‌تر

🔥 <b>حالا عکس رسید خود را ارسال کنید...</b>";
    }
    
    /**
     * 📱 پیام موبایل OTP ارسال شده - ✅ جدید
     */
    public static function getOTPSentMessage($otp, $mobile) {
        return "📱 <b>کد تایید ارسال شد</b>

━━━━━━━━━━━━━━━━━━━━

🔐 <b>کد تایید شما:</b> <code>{$otp}</code>

📞 <b>شماره موبایل:</b> <code>{$mobile}</code>

━━━━━━━━━━━━━━━━━━━━

⏰ <b>مدت اعتبار:</b> 5 دقیقه

🔒 <b>امنیت:</b> این کد فقط برای شما ارسال شده

✍️ <b>کد را در پیام بعدی وارد کنید:</b>";
    }
}
?>