            .btn-action:hover {
                transform: translateY(-2px);
                box-shadow: 0 5px 15px rgba(33, 147, 176, 0.4);
                color: white;
                text-decoration: none;
            }
            .license-display {
                background: #f8f9fa;
                border: 2px dashed #28a745;
                border-radius: 12px;
                padding: 15px;
                font-family: 'Courier New', monospace;
                word-break: break-all;
                font-size: 0.9rem;
                margin: 15px 0;
            }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="success-container">
                <div class="success-header">
                    <div class="success-icon">
                        <i class="bi bi-check-circle-fill"></i>
                    </div>
                    <h1 class="mb-0">پرداخت موفق!</h1>
                    <p class="mb-0 opacity-75"><?= htmlspecialchars($message) ?></p>
                </div>
                
                <div class="success-body">
                    <?php if ($payment): ?>
                        <div class="info-card">
                            <h5><i class="bi bi-info-circle me-2"></i>اطلاعات پرداخت</h5>
                            <div class="row">
                                <div class="col-sm-6">
                                    <strong>مبلغ:</strong> <?= number_format($payment['amount']) ?> تومان
                                </div>
                                <div class="col-sm-6">
                                    <strong>کد پیگیری:</strong> <?= $ref_id ?: $payment['id'] ?>
                                </div>
                                <div class="col-sm-6">
                                    <strong>تاریخ:</strong> <?= date('Y/m/d H:i') ?>
                                </div>
                                <div class="col-sm-6">
                                    <strong>وضعیت:</strong> <span class="text-success">تکمیل شده</span>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <?php if ($license_result): ?>
                        <div class="info-card">
                            <h5><i class="bi bi-key me-2"></i>لایسنس شما</h5>
                            <p>لایسنس دوره با موفقیت ایجاد شد:</p>
                            <div class="license-display">
                                <?= htmlspecialchars($license_result['license_key']) ?>
                            </div>
                            <div class="d-grid gap-2 mt-3">
                                <a href="<?= htmlspecialchars($license_result['download_url']) ?>" 
                                   class="btn-action text-center" target="_blank">
                                    <i class="bi bi-download me-2"></i>
                                    دانلود اپلیکیشن SpotPlayer
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <div class="info-card">
                        <h5><i class="bi bi-lightbulb me-2"></i>مراحل بعدی</h5>
                        <ol class="mb-0">
                            <?php if ($license_result): ?>
                                <li>اپلیکیشن SpotPlayer را دانلود کنید</li>
                                <li>لایسنس را در اپلیکیشن وارد کنید</li>
                                <li>از تمام ویدیوهای آموزشی لذت ببرید</li>
                                <li>در ربات تلگرام با لایسنس خود وارد شوید</li>
                            <?php else: ?>
                                <li>لایسنس شما در حال آماده‌سازی است</li>
                                <li>تا چند ساعت آینده برایتان ارسال می‌شود</li>
                                <li>برای پیگیری با پشتیبانی تماس بگیرید</li>
                            <?php endif; ?>
                        </ol>
                    </div>
                    
                    <div class="text-center mt-4">
                        <a href="https://t.me/<?= str_replace('@', '', BOT_USERNAME) ?>" 
                           class="btn-action me-3">
                            <i class="bi bi-telegram me-2"></i>
                            ربات تلگرام
                        </a>
                        <a href="https://t.me/<?= str_replace('@', '', SUPPORT_USERNAME) ?>" 
                           class="btn-action">
                            <i class="bi bi-headset me-2"></i>
                            پشتیبانی
                        </a>
                    </div>
                    
                    <div class="text-center mt-4">
                        <small class="text-muted">
                            💎 به خانواده کاپیتان ترید خوش آمدید!
                        </small>
                    </div>
                </div>
            </div>
        </div>
        
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
        <script>
            // Auto copy license to clipboard
            <?php if ($license_result): ?>
            navigator.clipboard.writeText('<?= addslashes($license_result['license_key']) ?>').then(function() {
                console.log('License copied to clipboard');
            });
            <?php endif; ?>
            
            // Confetti animation
            if (typeof confetti !== 'undefined') {
                confetti({
                    particleCount: 100,
                    spread: 70,
                    origin: { y: 0.6 }
                });
            }
        </script>
    </body>
    </html>
    <?php
}

/**
 * Show error page
 */
function showErrorPage($message, $payment = null) {
    ?>
    <!DOCTYPE html>
    <html dir="rtl" lang="fa">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>خطا در پرداخت - کاپیتان ترید</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
        <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css" rel="stylesheet">
        <style>
            body {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                min-height: 100vh;
                display: flex;
                align-items: center;
                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            }
            .error-container {
                background: white;
                border-radius: 20px;
                box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
                overflow: hidden;
                max-width: 600px;
                margin: 0 auto;
            }
            .error-header {
                background: linear-gradient(45deg, #dc3545, #e83e8c);
                color: white;
                text-align: center;
                padding: 40px 20px;
            }
            .error-icon {
                font-size: 4rem;
                margin-bottom: 20px;
                animation: shake 1s ease;
            }
            @keyframes shake {
                0%, 100% { transform: translateX(0); }
                25% { transform: translateX(-10px); }
                75% { transform: translateX(10px); }
            }
            .error-body {
                padding: 40px;
            }
            .info-card {
                background: #f8f9fa;
                border-radius: 12px;
                padding: 20px;
                margin: 20px 0;
                border-left: 4px solid #dc3545;
            }
            .btn-action {
                background: linear-gradient(45deg, #2193b0, #6dd5ed);
                border: none;
                border-radius: 12px;
                padding: 12px 30px;
                color: white;
                font-weight: 600;
                text-decoration: none;
                display: inline-block;
                transition: all 0.3s ease;
            }
            .btn-action:hover {
                transform: translateY(-2px);
                box-shadow: 0 5px 15px rgba(33, 147, 176, 0.4);
                color: white;
                text-decoration: none;
            }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="error-container">
                <div class="error-header">
                    <div class="error-icon">
                        <i class="bi bi-exclamation-triangle-fill"></i>
                    </div>
                    <h1 class="mb-0">خطا در پرداخت</h1>
                    <p class="mb-0 opacity-75"><?= htmlspecialchars($message) ?></p>
                </div>
                
                <div class="error-body">
                    <?php if ($payment): ?>
                        <div class="info-card">
                            <h5><i class="bi bi-info-circle me-2"></i>اطلاعات پرداخت</h5>
                            <div class="row">
                                <div class="col-sm-6">
                                    <strong>مبلغ:</strong> <?= number_format($payment['amount']) ?> تومان
                                </div>
                                <div class="col-sm-6">
                                    <strong>کد پرداخت:</strong> <?= $payment['id'] ?>
                                </div>
                                <div class="col-sm-6">
                                    <strong>تاریخ:</strong> <?= date('Y/m/d H:i') ?>
                                </div>
                                <div class="col-sm-6">
                                    <strong>وضعیت:</strong> <span class="text-danger">ناموفق</span>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <div class="info-card">
                        <h5><i class="bi bi-lightbulb me-2"></i>راه‌حل‌های پیشنهادی</h5>
                        <ul class="mb-0">
                            <li>دوباره تلاش کنید</li>
                            <li>از روش کارت به کارت استفاده کنید</li>
                            <li>با پشتیبانی تماس بگیرید</li>
                            <li>موجودی کارت خود را بررسی کنید</li>
                        </ul>
                    </div>
                    
                    <div class="text-center mt-4">
                        <a href="https://t.me/<?= str_replace('@', '', BOT_USERNAME) ?>" 
                           class="btn-action me-3">
                            <i class="bi bi-telegram me-2"></i>
                            تلاش مجدد
                        </a>
                        <a href="https://t.me/<?= str_replace('@', '', SUPPORT_USERNAME) ?>" 
                           class="btn-action">
                            <i class="bi bi-headset me-2"></i>
                            پشتیبانی
                        </a>
                    </div>
                    
                    <div class="text-center mt-4">
                        <small class="text-muted">
                            📞 پشتیبانی 24 ساعته در خدمت شما
                        </small>
                    </div>
                </div>
            </div>
        </div>
        
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    </body>
    </html>
    <?php
}
?>