<?php
/**
 * Quick Fix for Security and Telegram Issues
 */

require_once 'config.php';

echo "<h1>🔧 Quick Fix for Captain Trade Bot</h1>";

// Fix 1: Update Security patterns
$security_file = 'includes/security.php';
if (file_exists($security_file)) {
    $content = file_get_contents($security_file);
    
    // Remove 'admin' and 'captain' from suspicious patterns
    $old_pattern = "'admin', 'bot', 'test', 'spam', 'fake',\n            'captain', 'trade', 'forex', 'signal'";
    $new_pattern = "'bot', 'test', 'spam', 'fake'";
    
    $content = str_replace($old_pattern, $new_pattern, $content);
    file_put_contents($security_file, $content);
    
    echo "✅ Fixed security patterns<br>";
}

// Fix 2: Clear user blocks from database
try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
    
    // Unblock admin user
    $stmt = $pdo->prepare("UPDATE users SET is_blocked = 0, login_attempts = 0 WHERE username = ?");
    $stmt->execute(['capitantrade_admin']);
    
    // Unblock your user
    $stmt = $pdo->prepare("UPDATE users SET is_blocked = 0, login_attempts = 0 WHERE user_id = ?");
    $stmt->execute(['490288836']);
    
    echo "✅ Unblocked admin users<br>";
    
} catch (Exception $e) {
    echo "❌ Database error: " . $e->getMessage() . "<br>";
}

// Fix 3: Clear error logs
if (file_exists('logs/error.log')) {
    file_put_contents('logs/error.log', '');
    echo "✅ Cleared error logs<br>";
}

echo "<h2>🎯 Test Now:</h2>";
echo "<p>Send /start to @almascapitanbot</p>";
echo "<p>Both users should work now!</p>";
?>