<?php
// ===============================
// ربات تلگرام کاپیتان ترید - فقط پیام متنی و عکس از کاربر، همه فرمت‌ها از ادمین، امکان ریپلای مستقیم
// ===============================

define('BOT_TOKEN', '8188928831:AAElBDayTufpdYAj4sM2oGTTtT-WyOY9BOo');
define('API_URL', 'https://api.telegram.org/bot' . BOT_TOKEN . '/');
$ADMINS = [490288836, 5776796515];
$CHANNELS = [
    ['@capitantraderfx', 'https://t.me/capitantraderfx'],
    ['@capitan_nazarat', 'https://t.me/capitan_nazarat']
];
define('USERS_FILE', 'users.txt');
define('SETTINGS_FILE', 'settings.json');
date_default_timezone_set('Asia/Tehran');

$content = file_get_contents("php://input");
$update = json_decode($content, true);
if (!$update) exit();

// توابع ارسال
function sendMessage($chat_id, $text, $keyboard = null, $reply_to = null, $parse_mode = 'HTML') {
    $data = [
        'chat_id' => $chat_id,
        'text'    => $text,
        'parse_mode' => $parse_mode
    ];
    if ($keyboard) $data['reply_markup'] = json_encode($keyboard);
    if ($reply_to) $data['reply_to_message_id'] = $reply_to;
    file_get_contents(API_URL . "sendMessage?" . http_build_query($data));
}
function sendMedia($type, $chat_id, $file_id, $caption = '', $reply_to = null) {
    $data = [
        'chat_id' => $chat_id,
        $type => $file_id,
        'caption' => $caption,
        'parse_mode' => 'HTML'
    ];
    if ($reply_to) $data['reply_to_message_id'] = $reply_to;
    file_get_contents(API_URL . "send" . ucfirst($type) . "?" . http_build_query($data));
}
function forwardMessage($from_id, $to_id, $message_id, $caption = '') {
    $data = [
        'chat_id' => $to_id,
        'from_chat_id' => $from_id,
        'message_id' => $message_id
    ];
    file_get_contents(API_URL . "forwardMessage?" . http_build_query($data));
    if (!empty($caption)) {
        sendMessage($to_id, $caption);
    }
}
function isAdmin($id) {
    global $ADMINS;
    return in_array($id, $ADMINS);
}
function userExists($id) {
    return strpos(@file_get_contents(USERS_FILE), "$id|") !== false;
}
function saveUser($id, $name, $phone) {
    $line = "$id|$name|$phone|" . date("Y-m-d H:i:s") . "\n";
    file_put_contents(USERS_FILE, $line, FILE_APPEND);
}
function checkJoin($user_id) {
    global $CHANNELS;
    $results = [];
    foreach ($CHANNELS as $ch) {
        $ch_user = file_get_contents(API_URL . "getChatMember?chat_id={$ch[0]}&user_id={$user_id}");
        $res = json_decode($ch_user, true);
        $status = $res['result']['status'] ?? '';
        $results[] = ($status == 'member' || $status == 'administrator' || $status == 'creator');
    }
    return !in_array(false, $results);
}
function updateSettings($key, $value) {
    $settings = json_decode(file_get_contents(SETTINGS_FILE), true);
    $settings[$key] = $value;
    file_put_contents(SETTINGS_FILE, json_encode($settings, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
}
function getStats() {
    $lines = file_exists(USERS_FILE) ? file(USERS_FILE) : [];
    $all = count($lines);
    $today = $week = $month = 0;
    $now = time();
    foreach ($lines as $line) {
        $date = explode("|", $line)[3] ?? '';
        if (!$date) continue;
        $t = strtotime($date);
        if (date('Y-m-d', $t) == date('Y-m-d')) $today++;
        if ($now - $t < 7 * 86400) $week++;
        if (date('Y-m', $t) == date('Y-m')) $month++;
    }
    return [$today, $week, $month, $all];
}

// --- تنظیمات پیشفرض
if (!file_exists(SETTINGS_FILE)) {
    $default = [
        "welcome" => "🎉 خوش اومدی به خانواده کاپیتان ترید!\n\nاین‌جا مسیر موفقیتت رو با دوره ۵ مرحله‌ای رایگان شروع کن! برای ثبت‌نام شماره موبایل رو با دکمه زیر بفرست 👇",
        "free_course" => "🚀 <b>دوره رایگان فرمول ۵ مرحله‌ای کاپیتان</b>\nقدم به قدم یاد می‌گیرى چطور حرفه‌ای ترید کنی!\n\nبرای ورود به کانال دوره رایگان روی لینک زیر کلیک کن 👇\n" . $CHANNELS[0][1],
        "pls_course" => "🌟 <b>دوره اصلی سیستم PLS کاپیتان</b>\nاگه دنبال درآمد عالی و یادگیری حرفه‌ای هستی، این فرصت رو از دست نده!\n\nبرای ثبت‌نام و مشاوره بیشتر با ما ارتباط بگیر.",
        "support" => "📞 ارتباط مستقیم با کاپیتان\nفقط پیام متنی یا عکس ارسال کنید. پیام شما برای پشتیبانی ارسال می‌شود و به زودی پاسخ داده خواهد شد."
    ];
    file_put_contents(SETTINGS_FILE, json_encode($default, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
}
$settings = json_decode(file_get_contents(SETTINGS_FILE), true);

// --- دریافت اطلاعات پیام
$message = $update['message'] ?? $update['callback_query']['message'] ?? null;
$from = $message['from'] ?? null;
$user_id = $from['id'] ?? null;
$text = $message['text'] ?? '';
$data = $update['callback_query']['data'] ?? null;

// --- منوی اصلی کاربر با ایموجی و متن جذاب
function mainMenu($uid) {
    global $ADMINS;
    $is_admin = in_array($uid, $ADMINS);
    $keyb = [
        [['text' => '🚀 ثبت‌نام دوره رایگان']],
        [['text' => '🌟 دوره اصلی سیستم PLS']],
        [['text' => '📞 ارتباط با کاپیتان']]
    ];
    if ($is_admin) $keyb[] = [['text'=>'🛠 پنل مدیریت']];
    sendMessage($uid, "👇 از منو انتخاب کن:", [
        'keyboard' => $keyb, 'resize_keyboard' => true
    ]);
}

// --- منوی مدیریت نمایشی
function adminPanel($uid) {
    sendMessage($uid, "پنل مدیریت:", [
        'keyboard' => [
            [['text' => '📊 آمار کاربران'], ['text' => '✍️ تغییر پیام خوش‌آمدگویی']],
            [['text' => '📝 متن دوره رایگان'], ['text' => '🌟 متن دوره اصلی'], ['text' => '🔧 متن ارتباط با کاپیتان']],
            [['text' => '📢 پیام گروهی'], ['text' => 'بازگشت به منوی اصلی']]
        ], 'resize_keyboard' => true
    ]);
}

// --- ثبت نام و شروع
if ($text == '/start' || $data == 'start') {
    if (!userExists($user_id)) {
        sendMessage($user_id, $settings['welcome'], [
            'keyboard' => [
                [['text' => '📱 ارسال شماره موبایل', 'request_contact' => true]]
            ], 'resize_keyboard' => true
        ]);
    } else {
        mainMenu($user_id);
    }
    exit;
}

// --- دریافت شماره موبایل
if (isset($message['contact']) && $message['contact']['user_id'] == $user_id) {
    $phone = $message['contact']['phone_number'];
    sendMessage($user_id, "👤 نام و نام خانوادگی خود را وارد کنید:", null, null);
    file_put_contents("step_$user_id.txt", 'awaiting_name|' . $phone);
    exit;
}

// --- دریافت نام و نام خانوادگی
if (file_exists("step_$user_id.txt")) {
    $step = explode('|', file_get_contents("step_$user_id.txt"));
    if ($step[0] == 'awaiting_name') {
        $phone = $step[1];
        $name = $text;
        saveUser($user_id, $name, $phone);
        unlink("step_$user_id.txt");
        sendMessage($user_id, "لطفاً در هر دو کانال زیر عضو شو و بعد دکمه «عضو شدم ✅» رو بزن:\n\n1⃣ {$CHANNELS[0][1]}\n2⃣ {$CHANNELS[1][1]}", [
            'keyboard' => [
                [['text' => 'عضو شدم ✅']]
            ], 'resize_keyboard' => true
        ]);
        exit;
    }
}

// --- بررسی عضویت و نمایش منو
if ($text == 'عضو شدم ✅') {
    if (checkJoin($user_id)) {
        mainMenu($user_id);
    } else {
        sendMessage($user_id, "❗️ هنوز عضو هر دو کانال نشدی! لطفاً دوباره بررسی کن و بعد دکمه رو بزن.");
    }
    exit;
}

// --- منوی اصلی کاربر
if ($text == '🚀 ثبت‌نام دوره رایگان') {
    sendMessage($user_id, $settings['free_course']);
    exit;
}
if ($text == '🌟 دوره اصلی سیستم PLS') {
    sendMessage($user_id, $settings['pls_course']);
    exit;
}
if ($text == '📞 ارتباط با کاپیتان') {
    sendMessage($user_id, "📝 فقط پیام متنی یا عکس خود را ارسال کنید.\nپیام شما برای پشتیبانی ارسال می‌شود و به زودی پاسخ داده خواهد شد.", [
        'keyboard' => [
            [['text' => 'بازگشت به منوی اصلی']]
        ], 'resize_keyboard' => true
    ]);
    file_put_contents("step_$user_id.txt", 'supporting');
    exit;
}

// --- بازگشت به منوی اصلی کاربر
if ($text == 'بازگشت به منوی اصلی') {
    mainMenu($user_id);
    if (file_exists("step_$user_id.txt")) unlink("step_$user_id.txt");
    exit;
}

// --- ارسال پیام کاربر به ادمین‌ها در حالت پشتیبانی فقط متن یا عکس
if (file_exists("step_$user_id.txt") && file_get_contents("step_$user_id.txt") === 'supporting' && !isAdmin($user_id)) {
    // فقط اگر پیام، متن یا عکس بود
    if ($text || isset($message['photo'])) {
        foreach ($ADMINS as $admin) {
            // فوروارد پیام کاربر به ادمین و ارسال پیام جداگانه با آیدی کاربر
            if (isset($message['message_id'])) {
                forwardMessage($user_id, $admin, $message['message_id']);
                sendMessage($admin, "[UserID: $user_id]");
            }
        }
        sendMessage($user_id, "✅ پیام شما ارسال شد. منتظر پاسخ باشید!");
    } else {
        sendMessage($user_id, "❗️ فقط پیام متنی یا عکس ارسال کنید.");
    }
    exit;
}

// --- ادمین ریپلای کند، پیام به کاربر ارسال شود (هر فرمتی)
if (isAdmin($user_id) && isset($message['reply_to_message'])) {
    $reply_txt = $message['reply_to_message']['text'] ?? '';
    if (preg_match('/\[UserID:\s*(\d+)\]/', $reply_txt, $m)) {
        $to = intval($m[1]);
        if ($text) sendMessage($to, $text);
        if (isset($message['photo'])) {
            $file_id = end($message['photo'])['file_id'];
            sendMedia('photo', $to, $file_id, $message['caption']);
        }
        if (isset($message['voice'])) {
            $file_id = $message['voice']['file_id'];
            sendMedia('voice', $to, $file_id, $message['caption']);
        }
        if (isset($message['video'])) {
            $file_id = $message['video']['file_id'];
            sendMedia('video', $to, $file_id, $message['caption']);
        }
        if (isset($message['document'])) {
            $file_id = $message['document']['file_id'];
            sendMedia('document', $to, $file_id, $message['caption']);
        }
        sendMessage($user_id, "✅ پاسخ به کاربر ارسال شد.");
        exit;
    }
}

// --- پنل مدیریت
if (isAdmin($user_id) && $text == '🛠 پنل مدیریت') {
    adminPanel($user_id);
    exit;
}

// --- آمار کاربران
if (isAdmin($user_id) && $text == '📊 آمار کاربران') {
    list($today, $week, $month, $all) = getStats();
    sendMessage($user_id, "📊 آمار کاربران:\nامروز: $today\nهفته: $week\nماه: $month\nکل: $all");
    exit;
}

// --- تغییر پیام خوش‌آمدگویی
if (isAdmin($user_id) && $text == '✍️ تغییر پیام خوش‌آمدگویی') {
    sendMessage($user_id, "پیام خوش‌آمدگویی جدید را ارسال کنید:", [
        'keyboard' => [
            [['text' => 'انصراف ✖️']]
        ], 'resize_keyboard' => true
    ]);
    file_put_contents("step_$user_id.txt", 'setwelcome');
    exit;
}
if (file_exists("step_$user_id.txt") && file_get_contents("step_$user_id.txt") == 'setwelcome' && isAdmin($user_id)) {
    if ($text === 'انصراف ✖️') {
        adminPanel($user_id);
        unlink("step_$user_id.txt");
        exit;
    }
    updateSettings('welcome', $text);
    sendMessage($user_id, "پیام خوش‌آمدگویی جدید ثبت شد.");
    adminPanel($user_id);
    unlink("step_$user_id.txt");
    exit;
}

// --- تغییر متن دوره رایگان
if (isAdmin($user_id) && $text == '📝 متن دوره رایگان') {
    sendMessage($user_id, "متن جدید دوره رایگان را ارسال کنید:", [
        'keyboard' => [
            [['text' => 'انصراف ✖️']]
        ], 'resize_keyboard' => true
    ]);
    file_put_contents("step_$user_id.txt", 'setfree');
    exit;
}
if (file_exists("step_$user_id.txt") && file_get_contents("step_$user_id.txt") == 'setfree' && isAdmin($user_id)) {
    if ($text === 'انصراف ✖️') {
        adminPanel($user_id);
        unlink("step_$user_id.txt");
        exit;
    }
    updateSettings('free_course', $text);
    sendMessage($user_id, "متن دوره رایگان آپدیت شد.");
    adminPanel($user_id);
    unlink("step_$user_id.txt");
    exit;
}

// --- تغییر متن دوره اصلی
if (isAdmin($user_id) && $text == '🌟 متن دوره اصلی') {
    sendMessage($user_id, "متن جدید دوره اصلی را ارسال کنید:", [
        'keyboard' => [
            [['text' => 'انصراف ✖️']]
        ], 'resize_keyboard' => true
    ]);
    file_put_contents("step_$user_id.txt", 'setpls');
    exit;
}
if (file_exists("step_$user_id.txt") && file_get_contents("step_$user_id.txt") == 'setpls' && isAdmin($user_id)) {
    if ($text === 'انصراف ✖️') {
        adminPanel($user_id);
        unlink("step_$user_id.txt");
        exit;
    }
    updateSettings('pls_course', $text);
    sendMessage($user_id, "متن دوره اصلی آپدیت شد.");
    adminPanel($user_id);
    unlink("step_$user_id.txt");
    exit;
}

// --- تغییر متن ارتباط با کاپیتان
if (isAdmin($user_id) && $text == '🔧 متن ارتباط با کاپیتان') {
    sendMessage($user_id, "متن جدید ارتباط مستقیم را ارسال کنید:", [
        'keyboard' => [
            [['text' => 'انصراف ✖️']]
        ], 'resize_keyboard' => true
    ]);
    file_put_contents("step_$user_id.txt", 'setsupport');
    exit;
}
if (file_exists("step_$user_id.txt") && file_get_contents("step_$user_id.txt") == 'setsupport' && isAdmin($user_id)) {
    if ($text === 'انصراف ✖️') {
        adminPanel($user_id);
        unlink("step_$user_id.txt");
        exit;
    }
    updateSettings('support', $text);
    sendMessage($user_id, "متن ارتباط با کاپیتان آپدیت شد.");
    adminPanel($user_id);
    unlink("step_$user_id.txt");
    exit;
}

// --- ارسال پیام گروهی
if (isAdmin($user_id) && $text == '📢 پیام گروهی') {
    sendMessage($user_id, "پیام خود را ارسال کنید (متنی، عکس، ویس، ویدیو و ...):", [
        'keyboard' => [
            [['text' => 'انصراف ✖️']]
        ], 'resize_keyboard' => true
    ]);
    file_put_contents("step_$user_id.txt", 'broadcast');
    exit;
}
if (file_exists("step_$user_id.txt") && file_get_contents("step_$user_id.txt") == 'broadcast' && isAdmin($user_id)) {
    if ($text === 'انصراف ✖️') {
        adminPanel($user_id);
        unlink("step_$user_id.txt");
        exit;
    }
    $lines = file(USERS_FILE);
    foreach ($lines as $line) {
        $uid = explode('|', $line)[0];
        if (isset($message['text'])) sendMessage($uid, $message['text']);
        if (isset($message['photo'])) {
            $file_id = end($message['photo'])['file_id'];
            sendMedia('photo', $uid, $file_id, $message['caption']);
        }
        if (isset($message['voice'])) {
            $file_id = $message['voice']['file_id'];
            sendMedia('voice', $uid, $file_id, $message['caption']);
        }
        if (isset($message['video'])) {
            $file_id = $message['video']['file_id'];
            sendMedia('video', $uid, $file_id, $message['caption']);
        }
        if (isset($message['document'])) {
            $file_id = $message['document']['file_id'];
            sendMedia('document', $uid, $file_id, $message['caption']);
        }
    }
    sendMessage($user_id, "پیام گروهی ارسال شد.");
    adminPanel($user_id);
    unlink("step_$user_id.txt");
    exit;
}

// --- بازگشت به منوی اصلی مدیریت
if (isAdmin($user_id) && $text == 'بازگشت به منوی اصلی') {
    mainMenu($user_id);
    exit;
}

// --- راهنما
if ($text == '/help') {
    sendMessage($user_id, "برای شروع /start را بزنید!");
}
?>