<?php
/**
 * ═══════════════════════════════════════════════════
 * ✍️ Professional Copywriting Messages
 * ═══════════════════════════════════════════════════
 * این فایل شامل تمام متن‌های بازاریابی و فروش است
 */

// ─────────────────────────────────────────────────
// 🏠 Welcome Messages
// ─────────────────────────────────────────────────

function getWelcomeMessage($first_name = '') {
    $name = $first_name ? " $first_name عزیز" : "";
    
    return "
🎯 <b>سلام$name، به تیم حرفه‌ای رابین هک خوش آمدید!</b>

✨ <b>چرا ما را انتخاب کنید؟</b>
━━━━━━━━━━━━━━━━━━━━
✅ <b>تضمین ۱۰۰٪ انجام کار</b> یا بازگشت وجه
⚡ <b>سرعت بالا:</b> انجام کار در کمتر از ۴۸ ساعت
🔒 <b>محرمانگی کامل:</b> حریم خصوصی شما محفوظ است
💎 <b>تیم متخصص:</b> بیش از ۵ سال تجربه
🎁 <b>پشتیبانی ۲۴/۷:</b> همیشه در کنار شما هستیم

🔥 <b>پیشنهاد ویژه:</b> ۲۰٪ تخفیف برای اولین خرید!

📌 از منوی زیر، خدمات موردنظرتان را انتخاب کنید 👇
";
}

// ─────────────────────────────────────────────────
// 🕵️ Service: Social Media Hacking
// ─────────────────────────────────────────────────

function getHackServiceMessage($is_first_purchase = false) {
    $original_price = PRICE_HACK;
    $discount = $is_first_purchase ? DISCOUNT_FIRST_BUY : 0;
    $final_price = $original_price - ($original_price * $discount / 100);
    
    $discount_text = $is_first_purchase 
        ? "\n🎁 <b>تخفیف ویژه اولین خرید:</b> $discount%\n<s>" . number_format($original_price) . "</s> تومان" 
        : "";
    
    return "
🕵️ <b>هک حرفه‌ای شبکه‌های اجتماعی</b>

━━━━━━━━━━━━━━━━━━━━
📱 <b>پلتفرم‌های پشتیبانی شده:</b>
▫️ تلگرام (Telegram)
▫️ اینستاگرام (Instagram)
▫️ واتساپ (WhatsApp)
▫️ روبیکا و ایتا
▫️ تمام شبکه‌های اجتماعی

━━━━━━━━━━━━━━━━━━━━
⭐ <b>ویژگی‌های خاص:</b>

🎯 <b>دسترسی کامل به اکانت هدف</b>
📊 <b>دریافت تمام پیام‌ها و فایل‌ها</b>
🔐 <b>عدم اطلاع کاربر از هک شدن</b>
⚡ <b>نصب بدون نیاز به دسترسی فیزیکی</b>
🛡️ <b>ضد ردیابی و کاملا مخفی</b>

━━━━━━━━━━━━━━━━━━━━
⏱ <b>زمان انجام کار:</b> ۲ تا ۴۸ ساعت$discount_text

💰 <b>قیمت نهایی:</b> <code>" . number_format($final_price) . "</code> تومان

━━━━━━━━━━━━━━━━━━━━
🔥 <b>چرا این سرویس استثنایی است؟</b>

✔️ استفاده از جدیدترین متدهای هک
✔️ تیم ۲۴ ساعته پشتیبانی
✔️ تضمین بازگشت وجه
✔️ رازداری کامل

⚠️ <b>توجه:</b> این سرویس فقط برای اهداف قانونی و با رضایت طرف مقابل ارائه می‌شود.

👇 برای خرید، روی دکمه زیر کلیک کنید:
";
}

// ─────────────────────────────────────────────────
// 🛡️ Service: Instagram Security
// ─────────────────────────────────────────────────

function getSecurityServiceMessage($is_first_purchase = false) {
    $original_price = PRICE_SECURITY;
    $discount = $is_first_purchase ? DISCOUNT_FIRST_BUY : 0;
    $final_price = $original_price - ($original_price * $discount / 100);
    
    $discount_text = $is_first_purchase 
        ? "\n🎁 <b>تخفیف ویژه اولین خرید:</b> $discount%\n<s>" . number_format($original_price) . "</s> تومان" 
        : "";
    
    return "
🛡️ <b>امنیت و بازگردانی اکانت اینستاگرام</b>

━━━━━━━━━━━━━━━━━━━━
🆘 <b>مشکلات قابل حل:</b>

🔴 <b>اکانت هک شده</b>
🔴 <b>پیج دیسیبل (Disable)</b>
🔴 <b>حذف پیج‌های فیک و جعلی</b>
🔴 <b>بازگردانی پسورد</b>
🔴 <b>رفع محدودیت‌های اینستاگرام</b>

━━━━━━━━━━━━━━━━━━━━
🔐 <b>خدمات امنیتی شامل:</b>

✅ <b>ضد هک کامل:</b> محافظت ۱۰۰٪ از اکانت
✅ <b>بازگردانی فوری:</b> دسترسی مجدد به پیج
✅ <b>حذف قطعی فیک:</b> گزارش و حذف پیج‌های تقلبی
✅ <b>مشاوره امنیتی رایگان:</b> آموزش حفاظت
✅ <b>پشتیبانی دائمی:</b> پس از انجام کار

━━━━━━━━━━━━━━━━━━━━
⏱ <b>زمان انجام:</b> ۶ تا ۷۲ ساعت$discount_text

💰 <b>قیمت نهایی:</b> <code>" . number_format($final_price) . "</code> تومان

━━━━━━━━━━━━━━━━━━━━
🎖 <b>تضمین‌های ما:</b>

🏆 بیش از ۲۰۰۰ پیج موفق بازگردانده شده
🏆 نرخ موفقیت ۹۸٪
🏆 بازگشت وجه در صورت عدم موفقیت
🏆 محرمانگی کامل اطلاعات

💬 سوال دارید؟ از پشتیبانی بپرسید!

👇 برای خرید، روی دکمه زیر کلیک کنید:
";
}

// ─────────────────────────────────────────────────
// 📦 Order Confirmation Messages
// ─────────────────────────────────────────────────

function getOrderCreatedMessage($order_id, $service, $amount) {
    return "
✅ <b>سفارش شما با موفقیت ثبت شد!</b>

━━━━━━━━━━━━━━━━━━━━
🆔 <b>شناسه سفارش:</b> <code>$order_id</code>
📦 <b>سرویس:</b> $service
💰 <b>مبلغ:</b> " . number_format($amount) . " تومان
🕐 <b>تاریخ ثبت:</b> " . date('Y/m/d H:i') . "

━━━━━━━━━━━━━━━━━━━━
📌 <b>مراحل بعدی:</b>

1️⃣ پرداخت مبلغ از طریق درگاه یا کارت به کارت
2️⃣ ارسال اطلاعات موردنیاز
3️⃣ شروع فرآیند توسط تیم ما
4️⃣ دریافت گزارش پیشرفت

⏰ <b>زمان پاسخگویی:</b> کمتر از ۳۰ دقیقه

🙏 از اعتماد شما سپاسگزاریم!
";
}

function getPaymentMethodsMessage() {
    return "
💳 <b>انتخاب روش پرداخت</b>

لطفاً یکی از روش‌های پرداخت زیر را انتخاب کنید:

━━━━━━━━━━━━━━━━━━━━
🔵 <b>پرداخت آنلاین (پیشنهادی)</b>
✔️ سریع و امن
✔️ تایید خودکار
✔️ شروع فوری کار

━━━━━━━━━━━━━━━━━━━━
🔶 <b>کارت به کارت</b>
✔️ بدون کارمزد
✔️ ارسال رسید
✔️ تایید در ۱۵ دقیقه

👇 روش موردنظر خود را انتخاب کنید:
";
}

function getCardToCardMessage() {
    return "
💳 <b>اطلاعات کارت به کارت</b>

━━━━━━━━━━━━━━━━━━━━
🏦 <b>بانک:</b> ملت
👤 <b>به نام:</b> " . CARD_NAME . "
💳 <b>شماره کارت:</b>

<code>" . CARD_NUMBER . "</code>

━━━━━━━━━━━━━━━━━━━━
📝 <b>راهنمای پرداخت:</b>

1️⃣ مبلغ را به کارت بالا واریز کنید
2️⃣ عکس یا اسکرین‌شات رسید را ارسال کنید
3️⃣ پشتیبانی ظرف ۱۵ دقیقه تایید می‌کند
4️⃣ کار شما فوراً شروع می‌شود

⚠️ <b>نکته مهم:</b> حتماً رسید پرداخت را ارسال کنید تا سفارش شما پردازش شود.

📤 رسید خود را ارسال کنید 👇
";
}

// ─────────────────────────────────────────────────
// 🎯 Urgency & Scarcity Messages
// ─────────────────────────────────────────────────

function getUrgencyMessage() {
    return "
⏰ <b>پیشنهاد محدود!</b>

🔥 فقط امروز: ۲۰٪ تخفیف ویژه!

⚡ تعداد محدود: ۵ سفارش باقی‌مانده
⏳ زمان باقی‌مانده: ۳ ساعت

این فرصت را از دست ندهید!
";
}

// ─────────────────────────────────────────────────
// 📊 Order Status Messages
// ─────────────────────────────────────────────────

function getOrderStatusMessage($status) {
    $messages = [
        'pending' => '⏳ <b>در انتظار پرداخت</b>\n\nلطفاً هزینه را پرداخت و رسید ارسال کنید.',
        'processing' => '🔄 <b>در حال انجام</b>\n\nتیم ما روی سفارش شما کار می‌کند.\nزمان تقریبی: ۲۴-۴۸ ساعت',
        'completed' => '✅ <b>تکمیل شده</b>\n\n🎉 سفارش شما با موفقیت انجام شد!\n\n⭐ لطفاً نظر خود را ثبت کنید.',
        'cancelled' => '❌ <b>لغو شده</b>\n\nسفارش شما لغو شد. برای اطلاعات بیشتر با پشتیبانی تماس بگیرید.'
    ];
    
    return $messages[$status] ?? 'وضعیت نامشخص';
}

// ─────────────────────────────────────────────────
// 🎁 Social Proof & Testimonials
// ─────────────────────────────────────────────────

function getSocialProofMessage() {
    return "
⭐ <b>نظرات مشتریان راضی ما</b>

━━━━━━━━━━━━━━━━━━━━
👤 <b>محمد.ر</b> - تهران
⭐⭐⭐⭐⭐
\"واقعاً حرفه‌ای بودن! تو ۲۴ ساعت کارم انجام شد. ممنون\"

👤 <b>سارا.م</b> - اصفهان
⭐⭐⭐⭐⭐
\"پیجم رو که هک شده بود بازگردوندن. عالی بودن!\"

👤 <b>علی.ک</b> - مشهد
⭐⭐⭐⭐⭐
\"قیمت مناسب، سرعت بالا، کیفیت عالی. پیشنهاد می‌کنم\"

━━━━━━━━━━━━━━━━━━━━
📊 <b>آمار ما:</b>
✅ +۲۰۰۰ مشتری راضی
✅ نرخ موفقیت ۹۸٪
✅ پشتیبانی ۲۴/۷

📢 برای مشاهده نمونه کارهای بیشتر، منو «نمونه‌کار» را ببینید.
";
}
?>