<?php
require_once 'config.php';

echo "<h2>🧪 تست اتصال به زرین‌پال</h2>";
echo "<hr>";

echo "<b>مرچنت کد:</b> " . ZARINPAL_MERCHANT . "<br>";
echo "<b>Callback URL:</b> " . ZARINPAL_CALLBACK . "<br><br>";

// تست درخواست پرداخت
$data = [
    'merchant_id' => ZARINPAL_MERCHANT,
    'amount' => 10000, // 10 هزار تومان برای تست
    'description' => 'تست اتصال',
    'callback_url' => ZARINPAL_CALLBACK
];

echo "<b>در حال ارسال درخواست به زرین‌پال...</b><br><br>";

$ch = curl_init('https://api.zarinpal.com/pg/v4/payment/request.json');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);

$result = curl_exec($ch);
$error = curl_error($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if($error) {
    echo "❌ <b style='color:red'>خطا در اتصال:</b><br>";
    echo "<pre>$error</pre>";
    exit;
}

echo "<b>HTTP Code:</b> $http_code<br><br>";

$result = json_decode($result, true);

echo "<b>پاسخ زرین‌پال:</b><br>";
echo "<pre style='background:#f4f4f4; padding:10px; direction:ltr;'>";
print_r($result);
echo "</pre>";

if(isset($result['data']['code'])) {
    $code = $result['data']['code'];
    
    if($code == 100) {
        echo "<br><h3 style='color:green'>✅ اتصال موفق!</h3>";
        echo "مرچنت کد صحیح است و زرین‌پال به درستی کار می‌کند.<br>";
        echo "Authority: " . $result['data']['authority'];
    } else {
        echo "<br><h3 style='color:orange'>⚠️ کد خطا: $code</h3>";
        echo "لطفاً مرچنت کد خود را بررسی کنید.";
    }
} elseif(isset($result['errors'])) {
    echo "<br><h3 style='color:red'>❌ خطا</h3>";
    echo "<pre>";
    print_r($result['errors']);
    echo "</pre>";
}
?>