<?php
/**
 * ═══════════════════════════════════════════════════
 * ✅ ZarinPal Payment Verification
 * ═══════════════════════════════════════════════════
 * این صفحه بعد از پرداخت کاربر توسط زرین‌پال فراخوانی می‌شود
 */

require_once 'config.php';
require_once HELPERS_DIR . 'database.php';
require_once MODULES_DIR . 'payment_gateway.php';
require_once MODULES_DIR . 'order_tracking.php';

$authority = $_GET['Authority'] ?? '';
$status = $_GET['Status'] ?? '';
$order_id = $_GET['order_id'] ?? '';
$user_id = $_GET['user_id'] ?? '';

if($status == 'OK' && $authority && $order_id) {
    $order = getOrder($order_id);
    
    if($order) {
        $amount = $order['amount'];
        
        // تایید پرداخت با زرین‌پال
        $verification = verifyZarinpalPayment($authority, $amount);
        
        if($verification['success']) {
            // بروزرسانی وضعیت سفارش
            updateOrderStatus($order_id, 'processing', 'پرداخت آنلاین با موفقیت انجام شد.');
            
            // بروزرسانی اطلاعات پرداخت
            $payments = loadPayments();
            foreach($payments as $pid => $payment) {
                if($payment['authority'] == $authority) {
                    updatePayment($pid, [
                        'status' => 'completed',
                        'ref_id' => $verification['ref_id'],
                        'verified_at' => time()
                    ]);
                    break;
                }
            }
            
            // اطلاع به کاربر
            apiRequest('sendMessage', [
                'chat_id' => $user_id,
                'text' => "
🎉 <b>پرداخت موفق!</b>

━━━━━━━━━━━━━━━━━━━━
✅ پرداخت شما با موفقیت انجام شد

🆔 <b>شناسه سفارش:</b> <code>$order_id</code>
💰 <b>مبلغ:</b> " . number_format($amount) . " تومان
🔢 <b>کد پیگیری:</b> <code>{$verification['ref_id']}</code>

━━━━━━━━━━━━━━━━━━━━
🔄 سفارش شما در حال پردازش است

تیم ما به زودی کار را شروع می‌کند و از پیشرفت آن مطلع خواهید شد.

🙏 از اعتماد شما سپاسگزاریم!
",
                'parse_mode' => 'HTML',
                'reply_markup' => json_encode([
                    'inline_keyboard' => [
                        [['text' => '🔍 مشاهده سفارش', 'callback_data' => "order_details_$order_id"]],
                        [['text' => '🏠 بازگشت به منو', 'callback_data' => 'back_main']]
                    ]
                ])
            ]);
            
            // اطلاع به ادمین
            apiRequest('sendMessage', [
                'chat_id' => ADMIN_ID,
                'text' => "
💰 <b>پرداخت آنلاین جدید!</b>

━━━━━━━━━━━━━━━━━━━━
🆔 <b>سفارش:</b> <code>$order_id</code>
👤 <b>کاربر:</b> <a href='tg://user?id=$user_id'>$user_id</a>
💰 <b>مبلغ:</b> " . number_format($amount) . " تومان
🔢 <b>کد پیگیری:</b> <code>{$verification['ref_id']}</code>
📦 <b>سرویس:</b> {$order['service']}

━━━━━━━━━━━━━━━━━━━━
✅ پرداخت تایید شد - کار را شروع کنید
",
                'parse_mode' => 'HTML',
                'reply_markup' => json_encode([
                    'inline_keyboard' => [
                        [['text' => '🔍 مشاهده جزئیات', 'callback_data' => "order_details_$order_id"]],
                        [['text' => '✉️ پیام به کاربر', 'callback_data' => "reply_user_$user_id"]]
                    ]
                ])
            ]);
            
            logActivity("Payment verified: Order $order_id, Ref ID: {$verification['ref_id']}");
            
            // نمایش صفحه موفقیت
            echo "
            <!DOCTYPE html>
            <html dir='rtl' lang='fa'>
            <head>
                <meta charset='UTF-8'>
                <meta name='viewport' content='width=device-width, initial-scale=1.0'>
                <title>پرداخت موفق</title>
                <style>
                    * { margin: 0; padding: 0; box-sizing: border-box; }
                    body {
                        font-family: 'Vazir', Tahoma, sans-serif;
                        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                        min-height: 100vh;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        color: #fff;
                    }
                    .container {
                        background: rgba(255,255,255,0.1);
                        backdrop-filter: blur(10px);
                        padding: 40px;
                        border-radius: 20px;
                        text-align: center;
                        max-width: 500px;
                        box-shadow: 0 8px 32px rgba(0,0,0,0.3);
                    }
                    .success-icon {
                        font-size: 80px;
                        margin-bottom: 20px;
                        animation: scaleIn 0.5s ease-out;
                    }
                    h1 { margin-bottom: 20px; font-size: 28px; }
                    .info {
                        background: rgba(255,255,255,0.2);
                        padding: 20px;
                        border-radius: 10px;
                        margin: 20px 0;
                        text-align: right;
                    }
                    .info p { margin: 10px 0; font-size: 16px; }
                    .btn {
                        display: inline-block;
                        padding: 15px 40px;
                        background: #fff;
                        color: #667eea;
                        text-decoration: none;
                        border-radius: 50px;
                        font-weight: bold;
                        margin-top: 20px;
                        transition: transform 0.3s;
                    }
                    .btn:hover { transform: scale(1.05); }
                    @keyframes scaleIn {
                        from { transform: scale(0); }
                        to { transform: scale(1); }
                    }
                </style>
            </head>
            <body>
                <div class='container'>
                    <div class='success-icon'>✅</div>
                    <h1>پرداخت موفق!</h1>
                    <p>پرداخت شما با موفقیت انجام شد</p>
                    
                    <div class='info'>
                        <p><strong>شناسه سفارش:</strong> $order_id</p>
                        <p><strong>مبلغ:</strong> " . number_format($amount) . " تومان</p>
                        <p><strong>کد پیگیری:</strong> {$verification['ref_id']}</p>
                    </div>
                    
                    <p style='margin: 20px 0;'>سفارش شما در حال پردازش است و به زودی از طریق ربات با شما تماس گرفته می‌شود.</p>
                    
                    <a href='https://t.me/" . BOT_USERNAME . "' class='btn'>بازگشت به ربات</a>
                </div>
            </body>
            </html>
            ";
        } else {
            // پرداخت ناموفق
            apiRequest('sendMessage', [
                'chat_id' => $user_id,
                'text' => "
❌ <b>خطا در تایید پرداخت</b>

متأسفانه پرداخت شما تایید نشد.

🔄 لطفاً مجدداً تلاش کنید یا با پشتیبانی تماس بگیرید.

💬 پشتیبانی: @" . BOT_USERNAME . "
",
                'parse_mode' => 'HTML'
            ]);
            
            echo "
            <!DOCTYPE html>
            <html dir='rtl' lang='fa'>
            <head>
                <meta charset='UTF-8'>
                <title>خطا در پرداخت</title>
                <style>
                    * { margin: 0; padding: 0; box-sizing: border-box; }
                    body {
                        font-family: Tahoma;
                        background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
                        min-height: 100vh;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        color: #fff;
                    }
                    .container {
                        background: rgba(255,255,255,0.1);
                        padding: 40px;
                        border-radius: 20px;
                        text-align: center;
                        max-width: 500px;
                    }
                    .error-icon { font-size: 80px; margin-bottom: 20px; }
                    .btn {
                        display: inline-block;
                        padding: 15px 40px;
                        background: #fff;
                        color: #f5576c;
                        text-decoration: none;
                        border-radius: 50px;
                        font-weight: bold;
                        margin-top: 20px;
                    }
                </style>
            </head>
            <body>
                <div class='container'>
                    <div class='error-icon'>❌</div>
                    <h1>خطا در تایید پرداخت</h1>
                    <p style='margin: 20px 0;'>متأسفانه پرداخت شما تایید نشد. لطفاً دوباره تلاش کنید.</p>
                    <a href='https://t.me/" . BOT_USERNAME . "' class='btn'>بازگشت به ربات</a>
                </div>
            </body>
            </html>
            ";
        }
    }
} else {
    // لغو پرداخت توسط کاربر
    if($user_id) {
        apiRequest('sendMessage', [
            'chat_id' => $user_id,
            'text' => "
🚫 <b>پرداخت لغو شد</b>

شما پرداخت را لغو کردید.

در صورت تمایل می‌توانید مجدداً اقدام به پرداخت کنید.

💬 سوال دارید؟ با پشتیبانی تماس بگیرید.
",
            'parse_mode' => 'HTML',
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    [['text' => '🔄 پرداخت مجدد', 'callback_data' => "pay_online_$order_id"]],
                    [['text' => '🏠 بازگشت به منو', 'callback_data' => 'back_main']]
                ]
            ])
        ]);
    }
    
    echo "
    <!DOCTYPE html>
    <html dir='rtl' lang='fa'>
    <head>
        <meta charset='UTF-8'>
        <title>لغو پرداخت</title>
        <style>
            * { margin: 0; padding: 0; box-sizing: border-box; }
            body {
                font-family: Tahoma;
                background: linear-gradient(135deg, #fbc2eb 0%, #a6c1ee 100%);
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                color: #333;
            }
            .container {
                background: #fff;
                padding: 40px;
                border-radius: 20px;
                text-align: center;
                max-width: 500px;
                box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            }
            .cancel-icon { font-size: 80px; margin-bottom: 20px; }
            .btn {
                display: inline-block;
                padding: 15px 40px;
                background: #667eea;
                color: #fff;
                text-decoration: none;
                border-radius: 50px;
                font-weight: bold;
                margin-top: 20px;
            }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='cancel-icon'>🚫</div>
            <h1>پرداخت لغو شد</h1>
            <p style='margin: 20px 0;'>شما پرداخت را لغو کردید. در صورت نیاز می‌توانید مجدداً اقدام کنید.</p>
            <a href='https://t.me/" . BOT_USERNAME . "' class='btn'>بازگشت به ربات</a>
        </div>
    </body>
    </html>
    ";
}
?>