<?php
/**
 * ═══════════════════════════════════════════════════
 * 🔗 Webhook Setup
 * ═══════════════════════════════════════════════════
 * این فایل را یک بار اجرا کنید تا webhook تنظیم شود
 * آدرس: https://yourdomain.com/webhook.php?setup=1
 */

require_once 'config.php';

if(isset($_GET['setup'])) {
    $webhook_url = 'https://capitanbours.ir/rabinhk/bot.php'; // آدرس دامین خود را وارد کنید
    
    $result = apiRequest('setWebhook', [
        'url' => $webhook_url,
        'drop_pending_updates' => true
    ]);
    
    if($result['ok']) {
        echo "✅ Webhook تنظیم شد!\n";
        echo "URL: $webhook_url\n";
        echo json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    } else {
        echo "❌ خطا در تنظیم Webhook:\n";
        echo json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    }
} elseif(isset($_GET['info'])) {
    $result = apiRequest('getWebhookInfo', []);
    echo "<pre>";
    echo json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    echo "</pre>";
} else {
    echo "
    <h2>راهنمای تنظیم Webhook</h2>
    <ul>
        <li><a href='?setup=1'>تنظیم Webhook</a></li>
        <li><a href='?info=1'>اطلاعات Webhook</a></li>
    </ul>
    ";
}
?>